/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.ILockStateChangeable;
import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.api.common.skill.ITickableSkill;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.skills.core.PlayerLevelTransactionValidator;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.S2C_NewSkillsPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PlayerSkillProvider
implements ISkillProvider,
ILockStateChangeable,
IPlayerCapEntry {
    private static final Marker SKILLS = MarkerManager.getMarker((String)"Skills");
    private final PlayerEntity player;
    private final Map<SkillType<?>, ISkill> unlockedSkills = new HashMap();
    private final SkillCache cache = new SkillCache();
    private IPlayerCapEntry.IClientSynchReq request = () -> {};

    public PlayerSkillProvider(PlayerEntity player) {
        this.player = player;
    }

    @Override
    public void tick(PlayerEntity player) {
        this.cache.getTickables().forEach(skill -> skill.onUpdate(player));
    }

    @Override
    public boolean hasSkill(SkillType<?> type) {
        return !type.isDisabled() && this.unlockedSkills.containsKey(type);
    }

    @Override
    public <S extends ISkill> S getSkill(SkillType<S> type) {
        return (S)this.unlockedSkills.get(type);
    }

    @Override
    public void lock(SkillType<?> type) {
        Object skill = this.getSkill(type);
        if (skill == null) {
            return;
        }
        skill.onDeactivate(this.player);
        this.unlockedSkills.remove(type);
        this.cache.compute();
        this.request.makeSyncRequest();
    }

    @Override
    public void setClientSynch(IPlayerCapEntry.IClientSynchReq request) {
        this.request = request;
    }

    @Override
    public void onLevelUp(int level, PlayerEntity player) {
        List<SkillType<?>> newlyAvailableList = ModRegistries.SKILLS.getValues().stream().filter(type -> type.getProperties().getTransactionValidator().getId() == PlayerLevelTransactionValidator.ID && type.getProperties().getRequiredLevel() == level && !type.isDisabled()).collect(Collectors.toList());
        int count = newlyAvailableList.size();
        if (count > 0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("text.player.available_skills", new Object[]{count}).func_240699_a_(TextFormatting.YELLOW), Util.field_240973_b_);
            NetworkManager.sendClientPacket((ServerPlayerEntity)player, new S2C_NewSkillsPacket(newlyAvailableList));
        }
        if (!player.field_70170_p.func_201670_d()) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(SoundEvents.field_187802_ec, SoundCategory.MASTER, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.75f, 1.0f));
        }
    }

    @Override
    public void doUnlock() {
        for (SkillType skill : ModRegistries.SKILLS) {
            this.unlock(skill, false);
        }
        this.cache.compute();
    }

    @Override
    public void doLock() {
        for (ISkill skill : this.unlockedSkills.values()) {
            skill.onDeactivate(this.player);
        }
        this.unlockedSkills.clear();
        this.cache.clear();
    }

    @Override
    public void unlock(SkillType<?> skillType) {
        this.unlock(skillType, true);
    }

    @Override
    public void unlock(SkillType<?> skillType, boolean sync) {
        if (skillType.isDisabled()) {
            return;
        }
        Object skill = skillType.instantiate();
        skill.onPurchase(this.player);
        this.unlockedSkills.put(skillType, (ISkill)skill);
        if (sync) {
            this.request.makeSyncRequest();
            this.cache.compute();
        }
    }

    @Override
    public int getFlag() {
        return 2;
    }

    @Override
    public void toNbt(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        this.unlockedSkills.values().forEach(skill -> this.skillToNbt((ISkill)skill, list));
        nbt.func_218657_a("skills", (INBT)list);
    }

    @Override
    public void fromNbt(CompoundNBT nbt) {
        this.unlockedSkills.clear();
        ListNBT list = nbt.func_150297_b("skills", 9) ? nbt.func_150295_c("skills", 10) : new ListNBT();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT cnbt = list.func_150305_b(i);
            this.skillFromNbt(cnbt);
        }
        this.cache.compute();
    }

    private void skillToNbt(ISkill skill, ListNBT listNBT) {
        SkillType<?> type = skill.getType();
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("type", type.getRegistryName().toString());
        CompoundNBT data = skill.saveData();
        if (data != null) {
            nbt.func_218657_a("data", (INBT)data);
        }
        listNBT.add((Object)nbt);
    }

    private void skillFromNbt(CompoundNBT nbt) {
        ResourceLocation key = new ResourceLocation(nbt.func_74779_i("type"));
        SkillType type = (SkillType)ModRegistries.SKILLS.getValue(key);
        if (type == null) {
            GunsRPG.log.error(SKILLS, "Unknown skill type: " + key);
            return;
        }
        Object skill = type.instantiate();
        if (nbt.func_150297_b("data", 10)) {
            CompoundNBT data = nbt.func_74775_l("data");
            skill.readData(data);
        }
        this.unlockedSkills.put(type, (ISkill)skill);
        skill.onPurchase(this.player);
    }

    private class SkillCache {
        private final List<ITickableSkill> tickables = new ArrayList<ITickableSkill>();
        private boolean requiresComputation = true;

        private SkillCache() {
        }

        public void compute() {
            this.clear();
            Collection collection = PlayerSkillProvider.this.unlockedSkills.values();
            for (ISkill skill : collection) {
                if (!(skill instanceof ITickableSkill)) continue;
                this.tickables.add((ITickableSkill)((Object)skill));
            }
            this.requiresComputation = false;
        }

        public void clear() {
            this.tickables.clear();
            this.requiresComputation = true;
        }

        public List<ITickableSkill> getTickables() {
            return this.get(() -> this.tickables);
        }

        private <T> T get(Supplier<T> supplier) {
            if (this.requiresComputation) {
                this.compute();
            }
            return supplier.get();
        }
    }
}

